/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console.info;

import filenet.sim.toolkit.console.IVWSIMConsoleStatusListener;
import filenet.sim.toolkit.console.VWSIMBaseNode;
import filenet.sim.toolkit.console.VWSIMConsoleActionCommand;
import filenet.sim.toolkit.console.VWSIMConsoleContextMenu;
import filenet.sim.toolkit.console.VWSIMConsoleMessage;
import filenet.sim.toolkit.console.VWSIMConsoleStatusEvent;
import filenet.sim.toolkit.console.info.VWSIMMessageTableModel;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWMouseActionListener;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;

public class VWSIMConsoleMessagePane
extends JScrollPane
implements ActionListener,
IVWSIMConsoleStatusListener,
IVWMouseActionListener {
    private VWSIMMessageTableModel m_tableModel = null;
    private VWTable m_messageTable = null;
    private Vector m_messageList = new Vector();
    private VWMouseAdapter m_aMouseAdapter = null;

    public VWSIMConsoleMessagePane() {
        this.createMessageTable();
        this.setOpaque(true);
        this.getViewport().add(this.m_messageTable);
        this.m_aMouseAdapter = new VWMouseAdapter(this);
        this.m_messageTable.addMouseListener(this.m_aMouseAdapter);
    }

    public void addMessage(int type, String msg, boolean bAppend) {
        if (bAppend) {
            this.m_messageList.add(new VWSIMConsoleMessage(type, msg));
        } else {
            this.m_messageList.insertElementAt(new VWSIMConsoleMessage(type, msg), 0);
        }
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        try {
            if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_CLEAR_MESSAGES) == 0) {
                this.m_tableModel.clearAll();
                this.m_messageTable.updateUI();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void consoleStatusChanged(VWSIMConsoleStatusEvent evt) {
        VWSIMBaseNode baseNode = evt.getBaseNode();
        try {
            int statusType = evt.getType();
            switch (statusType) {
                case 3: {
                    VWSIMConsoleMessage consoleMsg = evt.getMessage();
                    this.m_messageList.insertElementAt(consoleMsg, 0);
                    break;
                }
                case 2: {
                    this.m_tableModel.clearAll();
                    break;
                }
            }
            this.m_messageTable.updateUI();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void doubleClickedItem(MouseEvent event) {
    }

    public void createPopup(MouseEvent event) {
        try {
            if (this.m_tableModel.getRowCount() > 0) {
                VWSIMConsoleContextMenu mi = new VWSIMConsoleContextMenu(7, this);
                mi.show(event.getComponent(), event.getX(), event.getY());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createMessageTable() {
        int nColWidth = 0;
        try {
            this.m_tableModel = new VWSIMMessageTableModel(this.m_messageList);
            this.m_messageTable = new VWTable(this.m_tableModel);
            this.m_messageTable.setRowSelectionAllowed(false);
            this.m_messageTable.setColumnSelectionAllowed(false);
            this.m_messageTable.setShowGrid(false);
            TableColumn aColumn = this.m_messageTable.getColumn(this.m_messageTable.getColumnName(0));
            try {
                nColWidth = Integer.valueOf("20");
            }
            catch (Exception ex) {
                nColWidth = 20;
            }
            aColumn.setMaxWidth(nColWidth);
            aColumn.setMinWidth(nColWidth);
            aColumn = this.m_messageTable.getColumn(this.m_messageTable.getColumnName(1));
            try {
                nColWidth = Integer.valueOf("150");
            }
            catch (Exception ex) {
                nColWidth = 150;
            }
            aColumn.setMinWidth(nColWidth);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private boolean getStatusNode(VWSIMBaseNode aNode) {
        int rowCount = this.m_tableModel.getRowCount();
        String name = aNode.getName();
        String docID = aNode.getDocID();
        boolean bFound = false;
        return bFound;
    }

    protected void releaseResources() {
        if (this.m_messageTable != null) {
            this.m_messageTable.removeAll();
            this.m_messageTable = null;
        }
        this.m_tableModel = null;
        if (this.m_messageList != null) {
            this.m_messageList.removeAllElements();
            this.m_messageList = null;
        }
        if (this.m_aMouseAdapter != null) {
            this.m_aMouseAdapter.removeReferences();
            this.m_aMouseAdapter = null;
        }
        this.removeAll();
    }
}

